/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.init;

import com.mrcrayfish.goblintraders.entity.GoblinTraderEntity;
import com.mrcrayfish.goblintraders.entity.VeinGoblinTraderEntity;
import com.mrcrayfish.goblintraders.item.SupplierSpawnEggItem;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="goblintraders", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"goblintraders");
    public static final RegistryObject<EntityType<GoblinTraderEntity>> GOBLIN_TRADER = ModEntities.build("goblin_trader", GoblinTraderEntity::new, 0.5f, 1.0f);
    public static final RegistryObject<EntityType<VeinGoblinTraderEntity>> VEIN_GOBLIN_TRADER = ModEntities.build("vein_goblin_trader", VeinGoblinTraderEntity::new, 0.5f, 1.0f);

    private static <T extends Entity> RegistryObject<EntityType<T>> build(String id, Function<World, T> function, float width, float height) {
        EntityType type = EntityType.Builder.func_220322_a((entityType, world) -> (Entity)function.apply(world), (EntityClassification)EntityClassification.CREATURE).func_220321_a(width, height).setCustomClientFactory((spawnEntity, world) -> (Entity)function.apply((World)world)).func_206830_a(id.toString());
        return REGISTER.register(id, () -> type);
    }

    public static void registerEntityTypeAttributes() {
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)GOBLIN_TRADER.get()), (AttributeModifierMap)GoblinTraderEntity.prepareAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)VEIN_GOBLIN_TRADER.get()), (AttributeModifierMap)VeinGoblinTraderEntity.prepareAttributes().func_233813_a_());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void register(RegistryEvent.Register<EntityType<?>> event) {
        SupplierSpawnEggItem.updateEggMap();
    }
}

